%% Paths
addpath('visualization\')

%% Settings
% Settings for the  battery power profile selection
% Choose the vehicle
veh_shortName = "VECTO_group5";

% Case scenarios
% Select payload in kg
payLoad_save_array =  ["13400kg"]; % "13400kg", "Max"
% Select the mission. This must be an existing .mat file in the library
mission_name_array = ["RegionalDelivery","LongHaul"]; % RegionalDelivery, LongHaul
% Dimension battery
battery_overdimensioning_array = [0]; % -0.4:0.2:1

% Font and size axes plot
FontSize = 14;
FontName = 'Arial';

%% Plots battery profiles
% Combine arrays into a cell array
arrays = {payLoad_save_array, mission_name_array, battery_overdimensioning_array};
% Find the index of the array with length greater than 2
selectedIndex = find(cellfun(@length, arrays) >= 2, 1);
sim_array = arrays{selectedIndex};
if selectedIndex == 1
    legend_ = 'Payload: ' + payLoad_save_array;
elseif selectedIndex == 2
    legend_ = mission_name_array;
else
    legend_ = 'Battery oversizing: ' + string(battery_overdimensioning_array*100) + '%';
end

for mission_name = mission_name_array
    for payLoad_save = payLoad_save_array
        for battery_overdimensioning = battery_overdimensioning_array

            % Charging current
            if strcmp(mission_name,'LongHaul')
                chg_C_rate = 350/630; 
            elseif strcmp(mission_name,'RegionalDelivery')
                chg_C_rate = 100/470;
            end

            % Load the battery power profile obtained through the backward model
            saveName = join([veh_shortName, mission_name, ...
                    append('payLoad',payLoad_save),...
                    append('battOverdimensioning',string(battery_overdimensioning*100),'%')], '_');
            load(fullfile("..","Backward model","results",'BattPowerProfile',saveName));
            
            % Main profiles
            % mainProfiles(prof, veh);
            
            % Plot default profiles as a function of traveled distance
            flag = double(length(mission_name_array)>1) + double(length(payLoad_save_array)>1) ...
                + double(length(battery_overdimensioning_array)>1);
            number_of_simulations = double(flag==1)*(length(mission_name_array) + length(payLoad_save_array) ...
                + length(battery_overdimensioning_array)- 2);
            simulations.number_of_simulations = number_of_simulations;
            simulations.array = sim_array;
            simulations.legend = legend_;
            simulations.FontSize = FontSize;
            simulations.FontName = FontName;
            BattProfile(veh.batt, prof,'simulations',simulations,'FontSize',FontSize,'FontName',FontName)
            
            % Plot default profiles as a function of traveled distance
            BattProfile(veh.batt, prof,'cellLevel', true,'simulations',simulations,'FontSize',FontSize,'FontName',FontName)

        end
    end
end

% Legend
legend(legend_)
set(findall(gcf,'-property','FontSize'),'FontSize',FontSize)
set(findall(gcf,'-property','FontName'),'FontName',FontName)